%% Description
% Plots figure 9b: the power law  decay of the dimensionless adhesion 
% force to its equilibrium value in the contacting case.
%
% Shows the dynamics when H_\infty = 5 and \Gamma takes the values 50, 100.

%% Parameter Definitions
%
% G     Values of \Gamma.
%
% F     The adhesion force as calculated by the dynamical numerics
%
% t     The time of the corresponding adhesion force
%
% f     The equilibrium value of the adhesion force for each G
%
% col   Colour scheme for plot

clear all;close all;

%% Load data
load('figure9b.mat')

%% Plotting
loglog(t(:,1),f(1)-F(:,1),'m-.'), hold on
loglog(t(:,2),f(2)-F(:,2),'c')

% Add legend, axis labels, etc
legend('\Gamma = 50','\Gamma = 100')
xlabel('$t$','interpreter','latex')
ylabel('$F_\infty-F(t)$','interpreter','latex')
axis([1e-2 1e5 1e-4 1e0])

% Increase axis label size
set(findobj('type','axes'),'fontsize',20,'linewidth',2)

% Increase tick length
set(gca,'TickLength',2*get(gca,'TickLength'))

    